#!/usr/bin/env python3
import requests

# Send a prompt to the Ollama API
def ask_ollama(prompt):
    try:
        # Ollama API endpoint
        url = "http://192.168.19.15:11434/api/generate"
        
        # Payload for the API request
        payload = {
            "model": "deepseek-r1:8b",  # Replace with the correct model name
            "prompt": prompt,
            "stream": False  # Set to True if you want streaming responses
        }
        
        # Send the request to the Ollama API
        response = requests.post(url, json=payload)
        
        # Check if the request was successful
        if response.status_code == 200:
            # Parse the JSON response
            result = response.json()
            return result.get("response", "No response from model")
        else:
            print(f"Error: {response.status_code} - {response.text}")
            return None
    except Exception as e:
        print(f"Error sending request to Ollama: {e}")
        return None

# Main function
if __name__ == "__main__":
    # Define the prompt
    prompt = "What is 1 + 1?"
    
    # Send the prompt to Ollama
    print(f"Sending prompt: {prompt}")
    response = ask_ollama(prompt)
    
    if response:
        print("Model Response:")
        print(response)
    else:
        print("Failed to get a response from the model.")
