#!/usr/bin/env python3
import pandas as pd
import requests

# Load the CSV file
def load_csv(file_path):
    try:
        # Read the CSV file into a pandas DataFrame
        df = pd.read_csv(file_path)
        print("CSV file loaded successfully!")
        return df
    except Exception as e:
        print(f"Error loading CSV file: {e}")
        return None

# Send a prompt to Deepseek-R1 via Ollama API
def send_to_deepseek(prompt):
    try:
        # Ollama API endpoint
        url = "http://192.168.19.15:11434/api/generate"
        
        # Payload for the API request
        payload = {
            "model": "deepseek-r1:8b",  # Replace with the correct model name
            "prompt": prompt,
            "stream": False  # Set to True if you want streaming responses
        }
        
        # Send the request to the Ollama API
        response = requests.post(url, json=payload)
        
        # Check if the request was successful
        if response.status_code == 200:
            # Parse the JSON response
            result = response.json()
            return result.get("response", "No response from model")
        else:
            print(f"Error: {response.status_code} - {response.text}")
            return None
    except Exception as e:
        print(f"Error sending request to Deepseek-R1: {e}")
        return None

# Main function
if __name__ == "__main__":
    # Path to your CSV file
    csv_file_path = "data.csv"  # Replace with your CSV file path
    
    # Load the CSV file
    data = load_csv(csv_file_path)
    
    if data is not None:
        # Example: Send each row's data to Deepseek-R1
        for index, row in data.iterrows():
            # Create a prompt from the row data (modify as needed)
            prompt = f"Process this data: {row.to_dict()}"
            
            # Send the prompt to Deepseek-R1
            print(f"Sending prompt: {prompt}")
            response = send_to_deepseek(prompt)
            
            if response:
                print("Deepseek-R1 Response:")
                print(response)
                print("-" * 40)  # Separator for readability
