#include <Arduino.h>

SemaphoreHandle_t sem_boss;

void employee_talk(){
  Serial.println("Employee working...");
}

void boss(void *pvParameters){
  int count=0;
  while(true){
    Serial.print(count++);
    Serial.println(" Boss giveing the single...");
    xSemaphoreGive(sem_boss);
    Serial.println("Boss finished giveing the single...\n");
    vTaskDelay(5000);
  }
}

void employee(void *pvParameters){
  while(true){
    if ( xSemaphoreTake(sem_boss, portMAX_DELAY) ){
      employee_talk();
      Serial.println("Employee worked...Done\r\n");
    }
  }
}

void setup() {
  Serial.begin(115200);
  sem_boss = xSemaphoreCreateBinary();
  xTaskCreate(boss, "boss",         1024, NULL, 3, NULL);
  xTaskCreate(employee, "employee", 1024, NULL, 2, NULL);
}

void loop() { }
