#include <Arduino.h>

#define LED1  15
#define LED2  17

TaskHandle_t xHandle_1 = NULL;

void vBlink1Task(void * pvParameters){
  while(true){
    digitalWrite(LED1, !digitalRead(LED1));
    vTaskDelay(1000 / portTICK_PERIOD_MS);
  }
}

void vBlink2Task(void *pvParameters){
  int n = 0;
  while(true){
    digitalWrite(LED2, !digitalRead(LED2));
    vTaskDelay(100 / portTICK_PERIOD_MS);
    if(n++ > 50) {
      digitalWrite(LED2, LOW);
      vTaskDelete( xHandle_1 );
    }
  }
}

void setup() {
  Serial.begin(115200);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  xTaskCreate(vBlink1Task, "vBlink1Task", 1024, NULL, tskIDLE_PRIORITY, NULL);
  xTaskCreate(vBlink2Task, "vBlink2Task", 1024, NULL, tskIDLE_PRIORITY+1, &xHandle_1);

}

void loop() { }
