#include <Arduino.h>

SemaphoreHandle_t one_Hz_sem;
QueueHandle_t data_q_handle;
QueueSetHandle_t data_or_sem_qs_handle;

void producer_1Hz_sem(void *p)
{
  while (true)
  {    
    vTaskDelay(3000 / portTICK_PERIOD_MS);
    xSemaphoreGive(one_Hz_sem);    
  }
}


void producer_data(void *p)
{
  int x = 0;
  while (true)
  {
    // use with processor_1
    x = x+1; 
    // use with processer_2
    //x = random(0,10);
    xQueueSend(data_q_handle, &x, 0);
    vTaskDelay(((rand() % 1000) + 100) / portTICK_PERIOD_MS);
  }
}

void processor_1(void *p)
{
  int count = 0;
  while (true)
  {
    // DO NOT Do This
    // xSemaphoreTake(one_Hz_sem);
    QueueSetMemberHandle_t who_unblocked = xQueueSelectFromSet(data_or_sem_qs_handle, 2000);
    if (who_unblocked == one_Hz_sem)
    {
      if (xSemaphoreTake(one_Hz_sem, 0))
      {
        Serial.println("One Hz Timeout");
      }
      else
      {
        Serial1.println("Error, semaphore should not happen ");
      }
    }
    else if (who_unblocked == data_q_handle)
    {
      int y = 0;
      if(xQueueReceive(data_q_handle, &y, 0)){
        Serial.print("Retrive ");
        Serial.println( y );

      }else{
        Serial.println("Error, queueRx should not happen ");
      }
    }
    else
    {
      Serial.println("Invalid case should not print this line");
    }
    
  }
}






void processor_2(void *p)
{
  int sample[10];
  int count = 0;
  while (true)
  {
    // DO NOT Do This
    // xSemaphoreTake(one_Hz_sem);

    QueueSetMemberHandle_t who_unblocked = xQueueSelectFromSet(data_or_sem_qs_handle, 2000);
    if (who_unblocked == one_Hz_sem)
    {
      if (xSemaphoreTake(one_Hz_sem, 0))
      {
        Serial.println("One Hz Timeout");
        float avg = 0;
        for (int i = 0; i< count; i++){
          avg += sample[i];
        }
        avg = avg/count;
        count = 0;
        Serial.print("avg = ");
        Serial.println(avg);
      }
      else
      {
        Serial1.println("Error, semaphore should not happen ");
      }
    }
    else if (who_unblocked == data_q_handle)
    {
      int y = 0;
      if(xQueueReceive(data_q_handle, &y, 0)){
        Serial.print("Retrive ");
        Serial.println( y );
        sample[count++] = y;

      }else{
        Serial.println("Error, queueRx should not happen ");
      }
    }
    else
    {
      Serial.println("Invalid case should not print this line");
    }
    
  }
}





void setup()
{
  Serial.begin(115200);
  vTaskDelay(5000 / portTICK_PERIOD_MS);
  Serial.println("\r\n -------- FreeRTOS ESP32_Queue_SET_semp_que ----------");

  one_Hz_sem = xSemaphoreCreateBinary();
  data_q_handle = xQueueCreate(10, sizeof(int));
  // xQueueSetHandle ( no. of data_q(10) + no of Binary semaphore(1) )
  data_or_sem_qs_handle = xQueueCreateSet(10+1);

  // add one_Hz_sem to queueSet
  xQueueAddToSet(one_Hz_sem, data_or_sem_qs_handle);
  // add data_q_handle to queueSet
  xQueueAddToSet(data_q_handle, data_or_sem_qs_handle);

  xTaskCreate(producer_1Hz_sem, "producer_1Hz_sem", 1024, NULL, tskIDLE_PRIORITY - 1, NULL);
  xTaskCreate(producer_data, "producer_data", 1024, NULL, tskIDLE_PRIORITY - 1, NULL);
  xTaskCreate(processor_1, "processor_1", 1024, NULL, tskIDLE_PRIORITY - 1, NULL);
  //xTaskCreate(processor_2, "processor_2", 1024, NULL, tskIDLE_PRIORITY - 1, NULL);

}

void loop()
{
  // put your main code here, to run repeatedly:
}