#include <Arduino.h>

/** Structure to initialize Pixel task */
typedef struct
{
  int dio_pin;
  int delay_ms;
} LED_PIN;

static const char *pcTextForTask1 = "Task 1 is running.";
static const char *pcTextForTask2 = "Task 2 is running.";

/*
void vTask(void * pvParameters){
  char *pcTaskName;
  pcTaskName = (char*)pvParameters;
  while(true){
    Serial.println(pcTaskName);
    vTaskDelay(1000 / portTICK_PERIOD_MS);
  }
}
*/

void vBlink1Task(void *pvParameters)
{
  LED_PIN *config_pin = (LED_PIN *)pvParameters;
  int pin = config_pin->dio_pin;
  int delay_t = config_pin->delay_ms;
  pinMode(pin, OUTPUT);
  while (true)
  {
    digitalWrite(pin, !digitalRead(pin));
    vTaskDelay(delay_t / portTICK_PERIOD_MS);
    Serial.println("LED blink");
  }
  vTaskDelete(NULL);
  // we need to free malloc
  free((LED_PIN *)config_pin);
}
void setup()
{

  Serial.begin(115200);
  vTaskDelay(5000 / portTICK_PERIOD_MS);
  Serial.println("\r\n -------- FreeRTOS ESP32_xTaskParameter ----------");

  // We can declare following structure as following
  //LED_PIN pin_struct;
  //LED_PIN *config = &pin_struct;
  // or We can declare following
  LED_PIN *config = (LED_PIN *)malloc(sizeof(LED_PIN));
  if (config == NULL)
  {
    Serial.println("Cannot allocate memory area to structue");
  }
  // end of declare

  Serial.begin(115200);
  config->dio_pin = 12;
  config->delay_ms = 3000;
  //xTaskCreate(vTask, "vTask1", 1024, (void*)pcTextForTask1, tskIDLE_PRIORITY, NULL);
  xTaskCreate(vBlink1Task, "vBlink1Task", 1024, (void *)config, tskIDLE_PRIORITY + 1, NULL);
}

void loop() {}
