#include<Arduino.h>

SemaphoreHandle_t sem_printer;

void Printer(String value){
  Serial.println(value);
}

void print1Task(void *pvParameters){
  int i;
  while(true){
    // critical LOCK resource 
    if ( xSemaphoreTake(sem_printer, 2000) == pdTRUE ){
      Printer("Print form print1Task...");
        xSemaphoreGive(sem_printer);
    // UNLOCK resource
    }else{
      Serial.println("print1Task failed to get access Printer");
    }
    vTaskDelay(2000);
  }
}

void print2Task(void *pvParameters){
  while(true){
    // critical LOCK resource
    if ( xSemaphoreTake(sem_printer, 5000) == pdTRUE ){
      Printer("Print form print2Task...");
      // 1 experiment to lock mutex and not give will cause print1Task cannot access printer
      //vTaskDelay(5000);
      xSemaphoreGive(sem_printer);
    // UNLOCK resource
    }else{
      Serial.println("print2Task failed to get access Printer");
    }
    vTaskDelay(2000);

  }
}

void setup() {
  Serial.begin(115200);
  sem_printer = xSemaphoreCreateMutex();
  xTaskCreate(print1Task, "print1Task", 1024, NULL, 1, NULL);
  xTaskCreate(print2Task, "print2Task", 1024, NULL, 0, NULL);
}

void loop() {
  // put your main code here, to run repeatedly:
}
