#include <Arduino.h>
#include <freertos/timers.h>
#define LED1  12
#define LED2  17
TimerHandle_t blinkTimer;
TimerHandle_t serialTimer;
void vBlink1Task(void * pvParameters){
  
  while(true){
    digitalWrite(LED1, !digitalRead(LED1));
    vTaskDelay(1000 / portTICK_PERIOD_MS);
  }
}
void vBlink2Task(void *pvParameters){
  while(true){
    digitalWrite(LED2, !digitalRead(LED2));
    vTaskDelay(100 / portTICK_PERIOD_MS);
  }
}
void vBlinkTimerCallback( TimerHandle_t xTimer ){
  uint32_t id = ( uint32_t )pvTimerGetTimerID(xTimer);
  digitalWrite(2, LOW);
  vTaskDelay(200 / portTICK_PERIOD_MS);
  digitalWrite(2, HIGH);
}
void vSerialTimerCallack(TimerHandle_t xTimer){
  Serial.println("Serial tick!");
}

void setup(){
  Serial.begin(115200);
  pinMode(2, OUTPUT);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  xTaskCreate(vBlink1Task, "vBlink1Task", 1024, NULL, tskIDLE_PRIORITY, NULL);
  xTaskCreate(vBlink2Task, "vBlink2Task", 1024, NULL, tskIDLE_PRIORITY+1, NULL);


  blinkTimer = xTimerCreate("blinkTimer", 9000, pdTRUE, (void*)0, vBlinkTimerCallback);
  serialTimer = xTimerCreate("serialTimer", 3000, pdTRUE, (void*)1, vSerialTimerCallack);

  if (xTimerStart(blinkTimer, 100) != pdPASS ){
    Serial.println("Start blink timer failed!");
  }
  if (xTimerStart(serialTimer, 100) != pdPASS ){
    Serial.println("Start serial timer failed!");
  }
  
}

void loop(){ }
