#!/bin/bash

# Signal 2 is Ctrl+C
# Signal 20 is Ctrl+Z
# Okay disable it:
trap '' 2 20


##
# BASH menu script that checks:
#   - Memory usage
#   - CPU load
#   - Number of TCP connections 
#   - Kernel version
##

server_name=$(hostname)

function memory_check() {
    echo ""
	echo "Memory usage on ${server_name} is: "
	free -h
	echo ""
}

function cpu_check() {
    echo ""
	echo "CPU load on ${server_name} is: "
    echo ""
	uptime
    echo ""
}

function tcp_check() {
    echo ""
	echo "TCP connections on ${server_name}: "
    echo ""
	cat  /proc/net/tcp | wc -l
    echo ""
}

function kernel_check() {
    echo ""
	echo "Kernel version on ${server_name} is: "
	echo ""
	uname -r
    echo ""
}

function network_check() {
    echo ""
	echo "Network interface on ${server_name} is: "
	echo ""
	ip route
    echo ""
}
function all_checks() {
	memory_check
	cpu_check
	tcp_check
	kernel_check
        network_check
}



function WrongCommand(){
    echo ""
    echo "Wrong Command"
    echo ""
}

function LogOut(){
    echo ""
    echo "Log out"
    # $PPID is the process ID of the parent process
    #kill -HUP $PPID
     
}


submenu () {
  local PS3='Please enter sub option: '
  local options=("IP addr" "Gateway" "DNS" "Main menu")
  local opt
  select opt in "${options[@]}"
  do
      case $opt in
          "IP addr")
              echo "set IP addr 192.168.19.8 255.255.255.0 192.168.19.1 8.8.8.8"
              read ipaddr
              echo "you set ip addr $ipaddr"
              ./changeIP.sh $ipaddr
              ;;
          "Gateway")
              echo "you chose GW"
              ;;
          "DNS")
              echo "you chose DNS"
              ;;
          "Main menu")
              return
              ;;
          *) echo "invalid option $REPLY";;
      esac
  done
}


##
# Color  Variables
##
green='\e[32m'
blue='\e[34m'
clear='\e[0m'

##
# Color Functions
##

ColorGreen(){
	echo -ne $green$1$clear
}
ColorBlue(){
	echo -ne $blue$1$clear
}

menu(){
option=0
until [ "$a" = "0" ]; do
echo -ne "
My First Menu
$(ColorGreen '1)') Memory usage
$(ColorGreen '2)') CPU load
$(ColorGreen '3)') Number of TCP connections 
$(ColorGreen '4)') Kernel version
$(ColorGreen '5)') Check All
$(ColorGreen '6)') Network 
$(ColorGreen '7)') Configure Network
$(ColorGreen '0)') Exit
$(ColorBlue 'Choose an option:') "
        read a
        case $a in
	        1) memory_check ; menu ;;
	        2) cpu_check ; menu ;;
	        3) tcp_check ; menu ;;
	        4) kernel_check ; menu ;;
	        5) all_checks ; menu ;;
            6) network_check ; menu ;;
            7) config_network; submenu ;;
            0) LogOut; menu ;;
		#0) exit 0 ;;
		#*) echo -e $red"Wrong option."$clear; WrongCommand;;
        *) echo -e $red"Wrong option. "; WrongCommand;;
        #* ) tput setf 4;echo "Please enter 1, 2, 3, or 4";tput setf 4;
        esac
done
}

# Call the menu function
menu
