# check container ip
docker inspect -f '{{.Name}} - {{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}' $(docker ps -aq)

# insert via ES
curl -H "Content-Type: application/json" -XPOST "https://localhost:9200/test1/_doc" -d "{ \"id\" : 3 }" -u 'admin:admin' --insecure

# insert via logstash
curl -X POST -H "Content-Type: application/json" 'http://172.20.0.5:3111/test1' -d '{"ID":1 }'

# query via ES
curl -X GET -u 'admin:admin' --insecure https://127.0.0.1:9200/test1/_doc/_search?pretty


# config snapshot for index
curl -X PUT -u 'admin:admin' --insecure "https://127.0.0.1:9200/_snapshot/backup-repo?pretty" -H 'Content-Type: application/json' -d'
{
  "type": "fs",
  "settings": {
    "location": "/usr/share/elasticsearch/data/repo",
    "compress": true
  },
  "indices": "test1"
}'
# check snapshot setting
curl -X GET -u 'admin:admin' --insecure https://127.0.0.1:9200/_snapshot?pretty

# list snapshots
curl -X GET -u 'admin:admin' --insecure https://127.0.0.1:9200/_cat/snapshots/backup-repo?pretty

# take snapshot with only index "test1"
curl -X PUT -u 'admin:admin' --insecure https://127.0.0.1:9200/_snapshot/backup-repo/snapshot-1?pretty -H 'Content-Type: application/json' -d '
{ "indices": "test1", 
  "ignore_unavailable": true, 
  "include_global_state": false 
}'

# close index "test1" before restore
curl -X POST -u 'admin:admin' --insecure "https://127.0.0.1:9200/test1/_close?pretty"

# restore index "test1"
curl -X POST -u 'admin:admin' --insecure "https://127.0.0.1:9200/_snapshot/backup-repo/snapshot-4/_restore?pretty"

# delete snapshot
curl -X DELETE -u 'admin:admin' --insecure https://127.0.0.1:9200/_snapshot/backup-repo/snapshot-4?pretty


# insert via logstash port 31311
curl -H "Content-Type: application/json" -XPOST "http://192.168.128.5:31311" -d '{ "id":9 , "lat": 13.902, "lon": 100.642, "speed": 12.1 }' -u 'admin:admin' --insecure
# insert via logstach port 31311 without user lonin:password
curl -H "Content-Type: application/json" -XPOST "http://192.168.128.5:31311" -d '{ "id":10 , "lat": 13.902, "lon": 100.642, "speed": 11.1 }'
