#!/usr/bin/env python3

import logging
import snap7
import time

# for setup the Logo connection please follow this link
# http://snap7.sourceforge.net/logo.html


logging.basicConfig(level=logging.INFO)

# Siemens LOGO devices Logo 8 is the default
Logo_7 = True

logger = logging.getLogger(__name__)

plc = snap7.logo.Logo()
plc.connect("127.0.0.1", 0x0300, 0x0200, 102)

if plc.get_connected():
    logger.info("connected")
    print("-------- on connected ----------")
    time.sleep(10)
    print("--------- write to NI1 ---------")
    #NI1 = "V1.1"
    NAI1 = "VW8"
    plc.write(NAI1, 255)
    #print("read NI1=", str(plc.read(NI1)))


else:
    logger.error("Conncetion failed")

plc.disconnect()
logger.info("Disconnected")
plc.destroy()
