#!/usr/bin/env python3

import pylibmodbus
import time
import os



# Siemens LOGO! 8 Modbus TCP Configuration
PLC_IP = "192.168.1.103"  # Change this to your LOGO! 8 IP
PLC_PORT = 502  # Default Modbus TCP Port

# NAQ Register Mapping (Adjust based on Siemens LOGO! 8 documentation)
NAQ_START_REGISTER = 1  # Example: Start address of NAQ registers
NAQ_TOTAL_COUNT = 3  # Adjust based on the number of NAQs available
CHUNK_SIZE = 2  # Read registers in smaller chunks to avoid Modbus limits

# MQTT server
SERVER = "188.166.217.51"
MQ_USER = "t108"
MQ_PASS = "t108@kmitl"
TOPIC = "kmitlt108/data"

def main():
    """Read all NAQ (Network Analog Output) values from Siemens LOGO! 8."""
    modbus = pylibmodbus.ModbusTcp(PLC_IP, PLC_PORT)
    temp=[]
    try:
        if modbus.connect() == -1:
            print("❌ Failed to connect to Siemens LOGO! 8 PLC")
            return
        
        print("✅ Connected to Siemens LOGO! 8 PLC")

        # Read NAQ outputs in smaller chunks
        for start in range(NAQ_START_REGISTER, NAQ_START_REGISTER + NAQ_TOTAL_COUNT, CHUNK_SIZE):
            end = min(start + CHUNK_SIZE, NAQ_START_REGISTER + NAQ_TOTAL_COUNT)
            naq_values = modbus.read_registers(start, end - start)

            if naq_values is not None:
                for i, value in enumerate(naq_values):
                    if ( value != 0 ):
                        print(f"🔹 NAQ{start + i - NAQ_START_REGISTER + 1} (Register {start + i}) = {value}")
                        temp.append(value)
            else:
                print(f"⚠ Failed to read NAQ registers {start} to {end - 1}")

            time.sleep(0.1)  # Small delay to avoid overloading LOGO! 8

    except Exception as e:
        print(f"❌ Exception: {e}")

    finally:
        modbus.close()
        print("🔌 Disconnected from Siemens LOGO! 8 PLC")
        print(f"Temp={temp}")
        cmd = "mosquitto_pub -h %s -u %s -P %s -t \'%s\' -m \'{\"T1\":%s, \"T2\":%s}\' "
        cmd = cmd % (SERVER, MQ_USER, MQ_PASS, TOPIC, temp[0], temp[1]) 
        print(cmd)
        output = os.popen(cmd).read()

if __name__ == "__main__":
    main()

