#!/usr/bin/env python3

import pylibmodbus
import sys

# Siemens LOGO! 8 Modbus TCP Configuration
PLC_IP = "192.168.1.103"  # Change this to your LOGO! 8 IP
PLC_PORT = 502  # Default Modbus TCP Port

# NI Register Address
#NI1_REGISTER = 0  # NI1 is stored in Register 0
#WRITE_VALUE = 0x0F  # Value to write to NI1

NI1_REGISTER = int(sys.argv[1])
WRITE_VALUE =  int(sys.argv[2])

if (WRITE_VALUE == 1):
    WRITE_VALUE = 0x0F



def main():
    """Write to NI1 and verify the result."""
    modbus = pylibmodbus.ModbusTcp(PLC_IP, PLC_PORT)

    try:
        if modbus.connect() == -1:
            print("❌ Failed to connect to Siemens LOGO! 8 PLC")
            return
        
        print("✅ Connected to Siemens LOGO! 8 PLC")

        # Write 0 to NI1 (Register 0)
        cmd_status =  modbus.write_register(NI1_REGISTER, WRITE_VALUE)
        print(f"command status = {cmd_status}")
        if (cmd_status == None):
            print(f"✅ Successfully wrote {WRITE_VALUE} to NI1 (Register {NI1_REGISTER})")
        else:
            print(f"❌ Failed to write to NI1 (Register {NI1_REGISTER})")

        # Read back NI1 to confirm the write operation
        ni_value = modbus.read_registers(NI1_REGISTER, 1)
        if ni_value is not None:
            print(f"📖 NI1 (Register {NI1_REGISTER}) After Write = {ni_value[0]}")
        else:
            print("❌ Failed to verify NI1 value")

    except Exception as e:
        print(f"❌ Exception: {e}")

    finally:
        modbus.close()
        print("🔌 Disconnected from Siemens LOGO! 8 PLC")

if __name__ == "__main__":
    main()

