import logging

import snap7

# for setup the Logo connection please follow this link
# http://snap7.sourceforge.net/logo.html


logging.basicConfig(level=logging.INFO)

# Siemens LOGO devices Logo 8 is the default
Logo_7 = True

logger = logging.getLogger(__name__)

plc = snap7.logo.Logo()
plc.connect("192.168.0.3", 0x0300, 0x0200)

if plc.get_connected():
    logger.info("connected")
    NI1 = "V1.1"
    plc.write(NI1, 0)


else:
    logger.error("Conncetion failed")

plc.disconnect()
logger.info("Disconnected")
plc.destroy()
