#!/usr/bin/bash

logfile=/tmp/nodedb1.log
container_name=nodedb1
/usr/bin/docker start $container_name
echo "docker start $container_name" >> $logfile
sleep 10
if [ "$( docker container inspect -f '{{.State.Status}}' $container_name )" == "running" ]; then 
   echo "$container_name is running" >> $logfile
else
   echo "$container_name is not running, we will start again" >> $logfile
   /usr/bin/docker start $container_name
   echo "start $container_name Done!!" >> $logfile
fi

if [ "$( docker container inspect -f '{{.State.Status}}' $container_name )" == "running" ]; then
   cmd1="/usr/bin/docker exec -i $container_name mysql -uroot -pmypass -e \"STOP GROUP_REPLICATION;\" \
                      -e \"SET @@GLOBAL.group_replication_group_name='aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee';\" \
                      -e \"SET @@GLOBAL.group_replication_local_address='$container_name:33061';\"\
                      -e \"SET @@GLOBAL.group_replication_group_seeds='$container_name:33061,nodedb2:33061,nodedb3:33061';\" \
                      -e \"change master to master_user='repl' for channel 'group_replication_recovery';\" \
                      -e \"START GROUP_REPLICATION;\"  " 
   echo "$cmd1" >> $logfile
   eval "$cmd1" 2> /tmp/err.log 1>> $logfile
   sleep 10
   echo "$container_name join group_replication" >> $logfile
   cmd2="/usr/bin/docker exec -i $container_name mysql -uroot -pmypass -e \"SELECT * FROM performance_schema.replication_group_members;\" "
   echo "$cmd2" >> $logfile
   eval "$cmd2" 2> /tmp/err.log 1>> $logfile
else
   echo "$container_name still not start" >> $logfile 
fi
