#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import paho.mqtt.client as paho
from subprocess import Popen, PIPE
import os
import json

import logging
import datetime

DEBUG = False

############################################
#    Initial logging to file               #
############################################
# Gets or creates a logger
logger = logging.getLogger("mosq_sub_cmd_v1.py")
# set log level
logger.setLevel(logging.DEBUG)
# define file handler and set formatter
file_handler = logging.FileHandler('/tmp/mosq_sub_cmd_v1.log')
formatter = logging.Formatter(
    '%(asctime)s : %(levelname)s : %(name)s : %(message)s')
file_handler.setFormatter(formatter)
# add file handler to logger
logger.addHandler(file_handler)
logger.info("log start")

def is_json(myjson):
    try:
        json_object = json.loads(myjson)
    except ValueError as e:
        if (DEBUG):
            print("is_json() false")
        logger.error(f"is_json() False = {e}")
        return False
    if (DEBUG):
        print("is_json() True")
    logger.info("is_json() True")
    return True

def on_subscribe(client, userdata, mid, granted_qos):
    if (DEBUG):
        print("Subscribed: "+str(mid)+" "+str(granted_qos))

def process_id( resp ):
    try:
        if (DEBUG):
            print("id=%s cmd=%s " %( resp['id'], resp['cmd']))
        id = resp['id']
        cmd = resp['cmd']
        cmd = cmd
        if (DEBUG):
            print (cmd)
        logger.info(cmd)
        output = os.popen(cmd)
    except Exception as e:
        if (DEBUG):
            print(f"An error at process_id() :{e}")
        logger.error(f"process_id() error = {e}")
    return 

def on_message(client, userdata, msg):
    try:
        text = msg.payload.decode("utf-8")
        if (DEBUG):
            print(f"\r\n{datetime.datetime.now()} {msg.topic} {msg.qos} {text}")
        if ( is_json(text) == False ):
            if (DEBUG):
                print("not json")
        else:
            resp = json.loads(text)
            if (DEBUG):
                print( resp )
            logger.info( resp )
            process_id(resp)
    except Exception as e:
        if (DEBUG):
            print(f"An error at on_message() :{e}")
        logger.error(f"on_message() error = {e}")
    return

user = 'user1'
password = 'pass1234'
try:
    client = paho.Client(client_id="20250210", clean_session=False)
    client.username_pw_set(user, password=password)    #set username and password
    client.on_subscribe = on_subscribe
    client.on_message = on_message
    client.connect("127.0.0.1", 1883)
    client.subscribe("kmitlt108/cmd", qos=1)
    client.loop_forever()
except Exception as e:
    if (DEBUG):
        print(f"An error at mosq_sub :{e}")
    logger.error(f"mosq_sub error = {e}")
